::##################################################################################
:: Batchdatei zum Erstellen einer gpkg/fgdb aus Interlis Daten
:: Syntax: InterlisImportExport_Example datei.xtf import oder export, muss je nach Bedarf angepasst werden
:: 07.03.2024, Amt für Geoinformation Appenzell I.Rh., MEP
::##################################################################################
:: --createEnumTxtCol --createEnumColAsItfCode fehlen bewusst

@echo off
cls
color 1E
chcp 65001 > nul
title=Batchdatei zum Erstellen einer gpkg/fgdb Datenbank aus den Interlis Daten der Nutzungsplanung (Beispiel)
setlocal EnableDelayedExpansion

echo **************************************************************************
echo * Batchdatei zum Erstellen einer gpkg/fgdb aus Interlis Daten            *
echo * Kanton Appenzell Innerrhoden, Amt für Geoinformation AGI               *
echo * 07.03.2024, geoinformation@ai.ch                                       *
echo **************************************************************************

if "%1"=="" goto syntax
if "%2"=="" goto syntax

:: Variablen entsprechend setzen

for %%f in ("%1") do set dbname=%%~nf

set ili2db=c:\ili2db
set gpkg=ili2gpkg-5.1.0
set fgdb=ili2fgdb-5.1.0
set gpkgjar=ili2gpkg-5.1.0.jar
set fgdbjar=ili2fgdb-5.1.0.jar
set ilivalidatorjar=ilivalidator-1.14.1.jar

set modelname=AI_Nutzungsplanung_V2_3
set dataset=PR6984
set katalogset=AI_Nutzungsplanung_Codelisten_V2_3

:: ili2db Pfad und jar prüfen

:checkgpkg
if exist %ili2db%\%gpkg%\%gpkgjar% goto checkfgdb
echo ***** Siehe Readme: Interlissoftware herunterladen/Variablen in Batchdatei richtig setzen! *****
echo.
goto ende

:checkfgdb
if exist %ili2db%\%fgdb%\%fgdbjar% goto checkilivalidator
echo ***** Siehe Readme: Interlissoftware herunterladen/Variablen in Batchdatei richtig setzen! *****
echo.
goto ende

:checkilivalidator
if exist %ili2db%\ilivalidator\%ilivalidatorjar% goto javapath
echo ***** Siehe Readme: Interlissoftware herunterladen/Variablen in Batchdatei richtig setzen! *****
echo.
goto ende

:: Java Pfad auslesen

:javapath

FOR /F "tokens=1* delims=;+" %%A IN ('where java.exe') DO set javapath=%%A
if exist "%javapath%" goto progress
echo ***** JAVA ist nicht installiert! *****
echo.
goto ende

:progress

if "%2"=="import" goto import
if "%2"=="export" goto export
goto syntax

:import

:: Bestehende Datenbanken löschen

del "%dbname%.gpkg" >nul 2>&1
del "%dbname%.gpkg-journal" >nul 2>&1
del "*.log" >nul 2>&1

rmdir /q /s %dbname%.gdb >nul 2>&1

:: Modelle einlesen
echo.
echo ********************************************************************************
echo Modelle einlesen
echo ********************************************************************************
echo.

"%javapath%" -jar %ili2db%\%gpkg%\%gpkgjar% --schemaimport --log "gpkg_%dbname%_Schema.log" --dbfile %dbname%.gpkg --importTid --coalesceCatalogueRef --createNumChecks --createUnique --createFk --createFkIdx --coalesceMultiSurface --coalesceMultiLine --coalesceMultiPoint --coalesceArray --beautifyEnumDispName --createEnumColAsItfCode --createEnumTxtCol --createGeomIdx --createMetaInfo --expandMultilingual --createTypeConstraint --createEnumTabsWithId --createEnumTabs --createTidCol --smart1Inheritance --strokeArcs=False --createBasketCol=True --defaultSrsAuth EPSG --defaultSrsCode 2056 --preScript NULL --postScript NULL --iliMetaAttrs NULL --models %modelname%
"%javapath%" -jar %ili2db%\%fgdb%\%fgdbjar% --schemaimport --log "fgdb_%dbname%_Schema.log" --dbfile %dbname%.gdb  --importTid --coalesceCatalogueRef --createNumChecks --createUnique --createFk --createFkIdx --coalesceMultiSurface --coalesceMultiLine --coalesceMultiPoint --coalesceArray --beautifyEnumDispName --createEnumColAsItfCode --createEnumTxtCol --createGeomIdx --createMetaInfo --expandMultilingual --createTypeConstraint --createEnumTabsWithId --createEnumTabs --createTidCol --smart1Inheritance --strokeArcs=False --createBasketCol=True --defaultSrsAuth EPSG --defaultSrsCode 2056 --preScript NULL --postScript NULL --iliMetaAttrs NULL --models %modelname%

:: Kataloge einlesen

echo.
echo ********************************************************************************
echo Kataloge einlesen
echo ********************************************************************************
echo.

"%javapath%" -jar %ili2db%\%gpkg%\%gpkgjar% --update --disableValidation --skipGeometryErrors --sqlEnableNull --skipReferenceErrors --log "gpkg_%dbname%_Katalog.log" --dbfile %dbname%.gpkg --importTid --importBid --dataset %dataset% %katalogset%.xml
"%javapath%" -jar %ili2db%\%fgdb%\%fgdbjar% --update --disableValidation --skipGeometryErrors --sqlEnableNull --skipReferenceErrors --log "fgdb_%dbname%_Katalog.log" --dbfile %dbname%.gdb  --importTid --importBid --dataset %dataset% %katalogset%.xml

:: Daten einlesen

echo.
echo ********************************************************************************
echo Daten einlesen
echo ********************************************************************************
echo.

"%javapath%" -jar %ili2db%\%gpkg%\%gpkgjar% --update --disableValidation --skipGeometryErrors --sqlEnableNull --skipReferenceErrors --log "gpkg_%dbname%_Import.log" --dbfile %dbname%.gpkg --importTid --importBid --dataset %dataset% %dbname%.xtf
"%javapath%" -jar %ili2db%\%fgdb%\%fgdbjar% --update --disableValidation --skipGeometryErrors --sqlEnableNull --skipReferenceErrors --log "fgdb_%dbname%_Import.log" --dbfile %dbname%.gdb  --importTid --importBid --dataset %dataset% %dbname%.xtf

goto ende

:export

:: Daten exportieren

echo.
echo ********************************************************************************
echo Daten exportieren
echo ********************************************************************************
echo.

"%javapath%" -jar %ili2db%\%gpkg%\%gpkgjar% --export --disableValidation --skipGeometryErrors --sqlEnableNull --skipReferenceErrors --log "gpkg_%dbname%_Export.log" --dbfile %dbname%.gpkg --importTid --importBid --dataset %dataset% gpkg_%dbname%_export.xtf
"%javapath%" -jar %ili2db%\%fgdb%\%fgdbjar% --export --disableValidation --skipGeometryErrors --sqlEnableNull --skipReferenceErrors --log "fgdb_%dbname%_Export.log" --dbfile %dbname%.gdb  --importTid --importBid --dataset %dataset% fgdb_%dbname%_export.xtf

:: Daten validieren

echo.
echo ********************************************************************************
echo Daten validieren
echo ********************************************************************************
echo.

"%javapath%" -jar %ili2db%\ilivalidator\%ilivalidatorjar% --forceTypeValidation --log "gpkg_%dbname%_Validation.log" gpkg_%dbname%_export.xtf
"%javapath%" -jar %ili2db%\ilivalidator\%ilivalidatorjar% --forceTypeValidation --log "fgdb_%dbname%_Validation.log" fgdb_%dbname%_export.xtf

goto ende

:syntax
echo ***** Siehe Readme: interlisimportexport_example dateiname.xtf import oder interlisimportexport_example dateiname.xtf export *****

:ende
pause
